DROP PROCEDURE [hips].[AddressByPatientList]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Gets all the address records for a patient
-- =============================================
CREATE PROCEDURE [hips].[AddressByPatientList] 
(
	@PatientMasterId INT
)
AS
BEGIN
	SELECT  a.AddressId,
			a.AddressLine1,
			a.AddressLine2,
			a.PlaceName,
			a.AustralianStateId,
			st.Description AS AustralianStateName,
			a.InternationalStateCode,
			a.PostCode,
			a.CountryId,
			c.DESCRIPTION AS CountryName,
			a.AddressTypeId,
			at.DESCRIPTION AS AddressTypeDescription,
			a.DateCreated,
			a.UserCreated,
			a.DateModified,
			a.UserModified
			
	FROM  [hips].[PatientMasterAddress] as pma
	LEFT OUTER JOIN [hips].[Address] a ON a.AddressId = pma.AddressId
	LEFT OUTER JOIN [hips].[State] AS st ON st.StateID = a.AustralianStateId
	Inner JOIN [hips].[Country] AS c ON c.CountryId = a.CountryId
	INNER JOIN [hips].[AddressType] AS at ON at.AddressTypeId = a.AddressTypeId
	WHERE pma.PatientMasterId = @PatientMasterId
END
GO

